#!/bin/csh

#----------------------------------------------------#
# Note that nSigma is set to a slightly lower value  #
# than the default (5.0) to maximize the number of   #
# weak peaks to be reconstructed in this series of   #
# simulated data sets.                               #
#----------------------------------------------------#


rm -fr ft.smile*

set xT=1536

set nuslist=('rdm' 'mdd' 'pg2' 'pg1' 'pg0')

set n=0

while ($n < 10)
   @ n++
   set fidName = `printf ../fid/test%02d.fid $n`
   set ftDir   = `printf ft.smile%02d $n`
   mkdir $ftDir

   set k=0
   while ($k < ${#nuslist})
      @ k++
      set listName = `printf "../nuslist/nuslist%02d.%s" $n $nuslist[$k]`
      set ftName   = `printf "%s/%sSmile.ft2" $ftDir $nuslist[$k]`
      set logName  = `printf "%s/%sSmile.log" $ftDir $nuslist[$k]`

      nmrPipe -in $fidName \
      | nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
      | nmrPipe  -fn ZF -zf 2                               \
      | nmrPipe  -fn FT                                     \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
      | nmrPipe  -fn TP                                     \
      | nmrPipe  -fn SMILE -nDim 2 -sample $listName        \
                 -report 1 -nThread 2 -xT $xT -xzfSize 8192 \
                 -nSigma 4.5 -xP0 0 -xP1 0                  \
      | nmrPipe  -fn ZF -size 8192                          \
      | nmrPipe  -fn FT                                     \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
      | nmrPipe  -fn TP                                     \
         -ov -out $ftName

      mv smile.log $logName

   end
end
