#!/bin/csh

set n=0
set nuslist=('rdm' 'mdd' 'pg2' 'pg1' 'pg0')

set intScale  = 0.1
set sigma     = 1000.0 #thermal noise level

while ($n < 10)
   @ n++
   set inTab = `printf "../tab/peakIn%02d.tab" $n`

   set k=0
   while ($k < ${#nuslist})
      @ k++
      set spect     = `printf "ft.smile%02d/{%s}Smile.ft2" $n $nuslist[$k]`
      set outTabDir = `printf "{%s}Tab%02d"       $nuslist[$k] $n`
      set logName   = `printf "{%s}Smile%02d.out" $nuslist[$k] $n`

      rm -fr auxTab $outTabDir
      mkdir auxTab $outTabDir

      set level=`findLevel.py $spect $sigma`
      echo $n $nuslist[$k] $level

      findPeaks.py $spect $intScale $inTab $outTabDir $sigma $level >& $logName
   end
end

rm -fr temp.tab auxTab
