#!/bin/csh

set xT=1536

set nuslist=('rdm')

set n=3

   @ n++
   set fidName = `printf ../../fid/test%02d.fid $n`

   set k=0
      @ k++
      set listName = `printf "../../nuslist/nuslist%02d.%s" $n $nuslist[$k]`
      set ftName   = "test.ft2"

      nmrPipe -in $fidName \
      | nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
      | nmrPipe  -fn ZF -zf 2                               \
      | nmrPipe  -fn FT                                     \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
      | nmrPipe  -fn EXT -x1 2210 -xn 2260 -sw -round 2     \
      | nmrPipe  -fn TP                                     \
      | nmrPipe  -fn SMILE -nDim 2 -sample $listName        \
          -nSigma 4.5 -minTDL 0.25     -report 2 -nThread 2 -xT $xT -xzfSize 8192 \
      | nmrPipe  -fn ZF -zf 2 -auto                         \
      | nmrPipe  -fn FT                                     \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
      | nmrPipe  -fn TP                                     \
         -ov -out $ftName

