#!/bin/sh
# The next line restarts using nmrWish \
exec nmrWish "$0" -- -notk "$@"

set tabName  temp.tab
set specName [lindex $argv 2]
set tabCount 1

set sigma    [lindex $argv 3]
set level    [lindex $argv 4]

set tabDir [file dirname $tabName]

if {![file exists $tabDir]} {file mkdir $tabDir}


set thisSpecName $specName
set thisTabName  $tabName

set x1      1
set xN      5120
set xInc    5120
set xExtra  2
set xLast   [expr $xN + $xExtra + 1]

set y1      1
set yN      8192
set yInc    8192
set yExtra  10
set yLast   [expr $yN + $yExtra + 1]

    set yFirst  $y1

while {$yFirst <= 1 + $yN - $yExtra} \
   {
    set yNext [expr $yFirst+$yInc+2*$yExtra-1]
    if {$yNext > $yLast} {set yNext $yLast}

    set xFirst  $x1

while {$xFirst <= 1 + $xN - $xExtra} \
   {
    set xNext [expr $xFirst+$xInc+2*$xExtra-1]
    if {$xNext > $xLast} {set xNext $xLast}

    readROI -roi 1 \
       -ndim 2 -in $thisSpecName \
       -x X_AXIS $xFirst $xNext           \
       -y Y_AXIS $yFirst $yNext           \
       -verb

    pkFindROI -roi 1 \
      -sigma $sigma -pChi 0.0001 -plus $level -minus -$level \
      -dx        1    10 \
      -idx       1    10 \
      -tol    2.00  2.67 \
      -hiAdj  1.20  1.80 \
      -lw    15.00  5.00 \
       -sinc -mask -out $thisTabName -verb

    set xFirst [expr 1 + $xNext - 2*$xExtra]
   }
    set yFirst [expr 1 + $yNext - 2*$yExtra]
   }

exit
