#!/bin/csh

#---------------------Nota Bene---------------------#
# To obtain the correct results, users must install #
# Frank Delaglio's 9/1/2016 or later version of     #
# nmrPipe from the following IBBR site:             #
# <https://www.ibbr.umd.edu/nmrpipe/install.html>   #
# -scale = 1/1280/1024 = 7.6293945e-7               #
#---------------------------------------------------#
# The peak height can be impacted by the apodization#
# function. This effect can be empiracally estimated#
# by simulating 10 peaks with the linewidth used in #
# the input peak tables and peak picking them.      #
# The intensity ratio is used to adjust the scaling #
# factor such that the S/N is fixed for the peaks   #
# across the 10 data sets simulated using different #
# random seeds and linewidth.                       #
#---------------------------------------------------#

set nTab  = 10
set seeds = ( 31875   9741  13184  26769   3866  32352   1248  28452 11225    7607)
set scaF  = (7.6293945e-07 7.7102661e-07 7.7934265e-07 7.9307556e-07 8.0703735e-07 \
             8.1459045e-07 8.1993103e-07 8.2588195e-07 8.3778381e-07 8.4472656e-07)

set n=0
while ($n < $nTab)
   @ n++
   set tabName  = `printf tab/peakIn%02d.tab $n`
   set fidName  = `printf fid/test%02d.fid   $n`
   set ftName   = `printf ft.full/test%02d.ft2 $n`

   simTimeND      -in $tabName      \
   -xN 5120       -yN 8192          \
   -xT 1280       -yT 1536          \
   -xMODE Complex -yMODE Complex    \
   -xSW  9000.000 -ySW 10803.288    \
   -xOBS 900.274  -yOBS 900.274     \
   -xCAR 5.00     -yCAR 6.0         \
   -xLAB HN       -yLAB 1H          \
   -ndim 2        -aq2D States      \
   -xP0 0         -yP0 0            \
   -xP1 0         -yP1 0            \
   -rms 5         -iseed $seeds[$n] \
   -scale $scaF[$n]                 \
   -out $fidName -verb -ov

   ft2.com $fidName $ftName

end

exit 0

