#!/usr/bin/env python

import sys, subprocess
popen = subprocess.Popen

xSize   = 1280
ySize   = 1024
hdrSize = 512

nuslist = sys.argv[1]
fullFID = sys.argv[2]
nusFID  = sys.argv[3]

inUnit = open(fullFID, 'rb')

hdrData = inUnit.read(hdrSize*4)

fidData = inUnit.read(xSize*2*ySize*2*4)

inUnit.close()

inUnit  = open(nuslist, 'r')
samples = inUnit.readlines()
inUnit.close()

outUnit = open(nusFID, 'wb')

outUnit.write(hdrData)

nSamples = 0
for i in range(len(samples)):
   thisSample = int(samples[i].strip())
   bytesStart = xSize*4*thisSample*4
   bytesEnd   = bytesStart + xSize*4*4
   fid2Write  = fidData[bytesStart:bytesEnd]
   outUnit.write(fid2Write)
   nSamples += 1

outUnit.close()

cmdArg = nusFID + ' -yT ' + str(nSamples) + ' -yN ' + str(nSamples*2)
popen('sethdr ' + cmdArg, shell=True)



