#!/bin/csh

set yT=1536

set nuslist=('rdm' 'mdd' 'pg2' 'pg1' 'pg0')

set n=0
while ($n < 10)
   @ n++
   set fidName = `printf ../fid/test%02d.fid $n`
   set ftDir   = `printf ft.ist%02d $n`
   rm -fr $ftDir
   mkdir $ftDir

   set k=0
   while ($k < ${#nuslist})
      @ k++
      set listName = `printf "../nuslist/nuslist%02d.%s" $n $nuslist[$k]`
      set ftName   = `printf "%s/%sIST.ft2" $ftDir $nuslist[$k]`
      echo 'fid=' $fidName 'nuslist=' $listName 'spect=' $ftName

      rm -fr nus$n.fid nus$n.ft1 ist$n.ft1
      sparsify.py $listName $fidName nus$n.fid
      sethdr nus$n.fid -yT $yT

      nmrPipe -in nus$n.fid \
      | nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5    \
      | nmrPipe  -fn ZF -zf 2                               \
      | nmrPipe  -fn FT                                     \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
      | nmrPipe  -fn TP                                     \
        -out nus$n.ft1 -ov

      istHMS -ref 0 -vlist $listName -xN $yT -itr 400       \
             -user 1 -verb 0 < ./nus$n.ft1 >! ./ist$n.ft1

      sethdr ist$n.fft1 -xT 1280

      nmrPipe -in ist$n.ft1 \
      | nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 1 -c 0.5 -size $yT \
      | nmrPipe  -fn ZF -size 8192                                 \
      | nmrPipe  -fn FT                                            \
      | nmrPipe  -fn PS -p0 0 -p1 0 -di                            \
      | nmrPipe  -fn TP                                            \
         -ov -out $ftName

   end
end

exit 0

