#!/usr/bin/env python

import subprocess, math, re, sys
popen = subprocess.Popen

if (len(sys.argv) < 3):
   print("Usage: findLevel.py ft.smile01/rdmSmile.ft2 1000.0")
   exit()

specName = sys.argv[1]
sigma    = sys.argv[2]
level    = float(sigma)*50.0  #starting contour level

nPksExpd = 900
minNPks  = nPksExpd * 1.20
maxNPks  = nPksExpd * 1.25

downSF   = 0.98
upSF     = 1.02

maxTries = 100
nTries   = 0
while (nTries < maxTries):
   cmdArg  = specName + ' ' + sigma + ' ' + str(level)
   output  = popen('ctTest.tcl ' + cmdArg, shell=True, stderr=subprocess.PIPE).stderr.read()
   nNewPks = int(re.search('Finished detection, ([0-9]+) new peaks.', output).group(1))

   if (nNewPks >= minNPks and nNewPks <= maxNPks):
      sys.stdout.write("%0.1f" % level)
      break
   else:
      if (nNewPks < minNPks):
         level *= math.pow(downSF, float(minNPks)/float(nNewPks))
      if (nNewPks > maxNPks):
         level *= math.pow(upSF,   float(nNewPks)/float(maxNPks))

      nTries += 1

      if (nTries == maxTries):
         sys.stdout.write("%0.1f" % level)
         break

