#!/usr/bin/env python

import math, re, random, sys

tabList = ['../refTab', 'rdmTab', 'mddTab', 'pg2Tab', 'pg1Tab', 'pg0Tab']

nPks    = 10
nCol    = 100
xStart  = 85
xDist   = 50

xSW     = 9000.0
ySW     = 10803.288

xN      = 5120
yN      = 8192

nTab    = 10

wpkHi = 1.0e5
spkHi = 8.0e6
pkHiFactor = math.pow(spkHi/wpkHi, 1.0/9.0)

pkDict  = {}

xAxis   = {}
yAxis   = {}
xHz     = {}
yHz     = {}
xwHz    = {}
ywHz    = {}
pkHi    = {}
refHi   = {}
refPC   = {}
pkVol   = {}

rmsYHz  = {}
rmsYWHz = {}
rmsHi   = {}
devHi   = {}

avgFSHi = [0]*nPks

for tabDir in tabList:
   refHi[tabDir] = [0.0]*nTab
   refPC[tabDir] = [  0]*nTab
   for pk in range(nPks):
      xAxis[tabDir+','+str(pk+1)] = ['nan']*nCol*nTab
      yAxis[tabDir+','+str(pk+1)] = ['nan']*nCol*nTab
      xHz[tabDir+','+str(pk+1)]   = ['nan']*nCol*nTab
      yHz[tabDir+','+str(pk+1)]   = ['nan']*nCol*nTab
      xwHz[tabDir+','+str(pk+1)]  = ['nan']*nCol*nTab
      ywHz[tabDir+','+str(pk+1)]  = ['nan']*nCol*nTab
      pkHi[tabDir+','+str(pk+1)]  = ['nan']*nCol*nTab
      pkVol[tabDir+','+str(pk+1)] = ['nan']*nCol*nTab

for tNum in range(nTab):

   refHi[tabDir][tNum]  = 0

   #inUnit = open('../tab/peakIn'+str(tNum+1)+'.tab', "r")
   #peakTab = inUnit.readlines()
   #inUnit.close()

   #for line in peakTab:
   #   if "VARS" in line:
   #      continue
   #   if "FORMAT" in line:
   #      continue

   #   lineSplit = line.split()
   #   if len(lineSplit) == 6:
   #      xPos = float(lineSplit[1])
   #      yPos = float(lineSplit[2])
   #      pkHi = float(lineSplit[5])
   #      n    = int( round( math.log10(pkHi/wpkHi) / math.log10(pkHiFactor), 0 ) )
   #      n    = str(n + 1)
   #      k    = str( int(xPos) ) + ',' + n + ',' + str(tNum+1)
   #      pkDict[k] = [xPos, yPos, pkHi]


   for tabDir in tabList:
      for c in range(nCol):
         x = xStart + c * xDist
         cOffs   = c + tNum*nCol
         tabName = tabDir + "%02d" % (tNum+1) + '/test%04d.tab' % x
         inUnit  = open(tabName, 'r')
         peaks   = inUnit.readlines()
         inUnit.close()

         for line in peaks:
            if ('REMARK' in line):
               continue
            if ('DATA' in line):
               continue
            if ('VARS' in line):
               continue
            if ('FORMAT' in line):
               continue

            lineSplit = line.split()
            if (len(lineSplit) != 25):
               continue

            pkNum = int(re.search('p([\d]+)', lineSplit[22]).group(1))
            k     = tabDir + ',' + str(pkNum)

            xAxis[k][cOffs] = lineSplit[1]
            yAxis[k][cOffs] = lineSplit[2]
            xHz[k][cOffs]   = lineSplit[7]
            yHz[k][cOffs]   = lineSplit[8]
            xwHz[k][cOffs]  = lineSplit[11]
            ywHz[k][cOffs]  = lineSplit[12]
            pkHi[k][cOffs]  = lineSplit[17]
            pkVol[k][cOffs] = lineSplit[19]

      #use pk# 10, ie the strongest peak as the reference for normalizing all peak intensities
      k          = tabDir + ',10'
      for c in range(nCol):
         cOffs   = c + tNum*nCol
         if ( not math.isnan(float(pkHi[k][cOffs])) ):
            refPC[tabDir][tNum] += 1
            refHi[tabDir][tNum] += float(pkHi[k][cOffs])

      if (refPC[tabDir][tNum] != 0):
         refHi[tabDir][tNum] /= float(refPC[tabDir][tNum])
      else:
         refHi[tabDir][tNum] = float('nan')

      for c in range(nCol):
         cOffs = c + tNum*nCol
         for pk in range(nPks):
            k = tabDir + ',' + str(pk+1)
            pkHi[k][cOffs] = float(pkHi[k][cOffs]) / refHi[tabDir][tNum]
            if (tabDir == tabList[0]):
               avgFSHi[pk] += pkHi[k][cOffs]/float(nCol*nTab)

fullTab = tabList.pop(0)

nPickPks    = {}
sumXPos2    = {}
sumYPos2    = {}
sumXHz2     = {}
sumYHz2     = {}
sumXWHz2    = {}
sumYWHz2    = {}
sumDev4Hi   = {}
sumHi2      = {}
sumVol2     = {}

for tabDir in tabList:
   nPickPks[tabDir] = [0]*nPks
   sumXPos2[tabDir] = [0]*nPks
   sumYPos2[tabDir] = [0]*nPks
   sumXHz2[tabDir]  = [0]*nPks
   sumYHz2[tabDir]  = [0]*nPks
   sumXWHz2[tabDir] = [0]*nPks
   sumYWHz2[tabDir] = [0]*nPks
   sumDev4Hi[tabDir]= [0]*nPks
   sumHi2[tabDir]   = [0]*nPks
   sumVol2[tabDir]  = [0]*nPks

   for pk in range(nPks):
      k0 = fullTab+','+str(pk+1)
      k1 = tabDir + ',' + str(pk+1)
      for c in range(nCol):
         xPos = xStart + c*xDist
         for tNum in range(nTab):
            k3    = str(xPos)+','+str(pk+1)+','+str(tNum+1)
            k4 = tabDir + ',' + str(tNum+1)
            cOffs = c + tNum * nCol
            if (not math.isnan(float(xAxis[k0][cOffs])) and not math.isnan(float(xAxis[k1][cOffs]))):
               nPickPks[tabDir][pk] += 1
               sumXPos2[tabDir][pk] += pow( float(xAxis[k0][cOffs]) - float(xAxis[k1][cOffs]), 2 )
               sumYPos2[tabDir][pk] += pow( float(yAxis[k0][cOffs]) - float(yAxis[k1][cOffs]), 2 )
               #sumXPos2[tabDir][pk] += pow( pkDict[k3][0] - float(xAxis[k1][cOffs]), 2 )
               #sumYPos2[tabDir][pk] += pow( pkDict[k3][1] - float(yAxis[k1][cOffs]), 2 )

               sumXHz2[tabDir][pk]  += pow( float(xHz[k0][cOffs])   - float(xHz[k1][cOffs]),   2 )
               sumYHz2[tabDir][pk]  += pow( float(yHz[k0][cOffs])   - float(yHz[k1][cOffs]),   2 )

               sumXWHz2[tabDir][pk] += pow( float(xwHz[k0][cOffs])  - float(xwHz[k1][cOffs]),  2 )
               sumYWHz2[tabDir][pk] += pow( float(ywHz[k0][cOffs])  - float(ywHz[k1][cOffs]),  2 )

               sumHi2[tabDir][pk]   += pow( pkHi[k0][cOffs] - pkHi[k1][cOffs],                 2 )
               sumDev4Hi[tabDir][pk]+= pkHi[k1][cOffs] - pkHi[k0][cOffs]

      if (nPickPks[tabDir][pk] != 0):
         rmsYHz[k1]  = math.sqrt(sumYHz2[tabDir][pk]  / nPickPks[tabDir][pk])
         rmsYWHz[k1] = math.sqrt(sumYWHz2[tabDir][pk] / nPickPks[tabDir][pk])
         rmsHi[k1]   = math.sqrt(sumHi2[tabDir][pk]   / nPickPks[tabDir][pk]) / avgFSHi[pk]
         devHi[k1]   = sumDev4Hi[tabDir][pk]          / nPickPks[tabDir][pk]  / avgFSHi[pk]
      else:
         rmsYHz[k1]  = float('nan')
         rmsYWHz[k1] = float('nan')
         rmsHi[k1]   = float('nan')
         devHi[k1]   = float('nan')

print("rmsYHz")
for pk in range(nPks):
   for tabDir in tabList:
      k1 = tabDir + ',' + str(pk+1)
      sys.stdout.write( "%8.3f " % rmsYHz[k1] )
   print("")

print("rmsYWHz")
for pk in range(nPks):
   for tabDir in tabList:
      k1 = tabDir + ',' + str(pk+1)
      sys.stdout.write( "%8.3f " % rmsYWHz[k1] )
   print("")

print("pkHi RMSD relative to the refernce height")
for pk in range(nPks):
   for tabDir in tabList:
      k1 = tabDir + ',' + str(pk+1)
      sys.stdout.write( "%8.1f " % (rmsHi[k1]*100.0) )
   print("")

print("pkHi average deviation relative to the refernce height")
for pk in range(nPks):
   for tabDir in tabList:
      k1 = tabDir + ',' + str(pk+1)
      sys.stdout.write( "%8.1f " % (devHi[k1]*100.0) )
   print("")

exit()

