#!/usr/bin/env python

import subprocess, math, re, sys
popen = subprocess.Popen

if (len(sys.argv) < 5):
   print("Usage: findPeaks.py ft.full/test01.ft2 1.0 tab/peakIn01.tab fullTab01")
   exit()

specName   = sys.argv[1]
intScale  = float(sys.argv[2])
inPkTab   = sys.argv[3]
outTabDir = sys.argv[4]
sigma     = sys.argv[5]
minLevel  = sys.argv[6]

inUnit = open(inPkTab, "r")
peakTab = inUnit.readlines()
inUnit.close()

wpkHi = 1.0e5
spkHi = 8.0e6
pkHiFactor = math.pow(spkHi/wpkHi, 1.0/9.0)

pkDict = {}

for line in peakTab:
   if "VARS" in line:
      continue
   if "FORMAT" in line:
      continue

   lineSplit = line.split()
   if len(lineSplit) == 6:
      xPos = float(lineSplit[1])
      yPos = float(lineSplit[2])
      pkHi = float(lineSplit[5])
      n    = int( round( math.log10(pkHi/wpkHi) / math.log10(pkHiFactor), 0 ) )
      n    = str(n + 1)
      k    = str( int(xPos) ) + ',' + n
      pkDict[k] = [xPos, yPos, pkHi]

xPos0    = 85
xPosDist = 50
nCol     = 100
nPks     = 10

tabNum   = 0

ass      = re.compile('None')

for i in range(nCol):
   for j in range(nPks):
      xPos   = xPos0 + i*xPosDist
      k      = str(xPos) + ',' + str(j+1)
      xPos   = pkDict[k][0]
      xStart = xPos - 5
      xEnd   = xPos + 5
      yPos   = pkDict[k][1]
      yStart = yPos - 5
      yEnd   = yPos + 5
      pkHi   = pkDict[k][2]
      level  = pkHi*intScale*0.8

      if (j == 2):
        yExtra = ' 2 '
      else:
        yExtra = ' 4 '

      if (j == 0):
         tabName = outTabDir + '/test%04d.tab' % int(xPos)
         outUnit = open(tabName, 'w')

      tabNum += 1
      tabName = './auxTab/test' + ('%03d.tab' % tabNum)

      nTries = 0
      while (nTries<2):
         cmdArg  = tabName + ' ' + specName + ' ' + str(xStart) + ' ' + str(xEnd) + \
                   ' ' + str(yStart) + ' ' + str(yEnd) + yExtra + str(level) + ' ' + sigma

         output = popen('pkpick.tcl ' + cmdArg, shell=True, stderr=subprocess.PIPE).stderr.read()

         nNewPks = int(re.search('Finished detection, ([0-9]+) new peaks.', output).group(1))

         if (nNewPks >= 1):
            break
         else:
            level = float(minLevel)
            nTries += 1

            if (nTries == 2):
               print("no peak detected: Column = %4d  Row = %4d" % (int(xPos), int(yPos)))
               break

      if (nNewPks > 0 or j == 0):
         inUnit = open(tabName, 'r')
         assTab = inUnit.readlines()
         inUnit.close()
      else:
         if (j==9):
            outUnit.close()
         continue

      tmpHi = []
      for n in range(nNewPks):
         lastLn  = assTab[-1-n]
         tmpHi.append(float(lastLn.split()[17]))

      if (j==0):
         for line in assTab[0:-1-nNewPks]:
            outUnit.write(line)
      if (len(tmpHi) > 0):
         n = tmpHi.index(max(tmpHi))
         lastLn  = assTab[-1-n]
         assName = 'c%03d' % int(xPos) + 'p%02d' % (j+1)
         lastLn  = ass.sub(assName, lastLn, 0)
         outUnit.write(lastLn)

