#!/bin/csh

#------------------------------------------------------#
# The 3 indirect dimensions are extended by 50% from   #
# 56, 80, and 80 (corresponding to -yT, -zT, and -aT   #
# in fid.com) to 84, 120, and 120, respectively;       #
# see the input and reconstructed data sizes by:       #
# showhdr ft1/test001.ft1 ft1.smile/test001.ft1        #
# One can override this SMILE default by specifying    #
# -xT 56 -yT 80 -zT 80 to keep the size of data matrix #
# unchanged during the reconstruction, or to a larger  #
# number than the corresponding -T in fid.com to make  #
# a different amount of extension. A number smaller    #
# than the corresponding -T value in fid.com (for      #
# example -xT 50 smaller than -yT 56 in fid.com) is    #
# invalid and therefore is always ignored by SMILE.    #
# Note that the x-axis in fid.com is always flipped to #
# the a-axis, and the y-, z-, and a-axes in fid.com    #
# become x-, y-, and z-axes, respectively, for SMILE.  #
#------------------------------------------------------#
# "-maxMem 40" makes SMILE to run in the chunk-wise    #
# memory saving mode. Without this, by default, SMILE  #
# tries to allocate more than 2.5 TBs of memory for FT,#
# which may exceed the memory space one has access to. #
# However, when the maximal amount of memory is limited#
# to 40 GB, SMILE can still run even if one does not   #
# have 2.5 TB memory, as long as the memory space is   #
# sufficient for FT of at least 3 cubes of the 4D data.#
#------------------------------------------------------#

# The following thread affinity is not used in this example;
# It may improve the performance, depending on the hardware.
#setenv KMP_AFFINITY "verbose,granularity=fine,compact,1,0"

#Z=F1, 13C indirect dim (Cnoe)
#Y=F2, 1H indirect dim  (Hnoe)
#A=F3, 13C indirect dim (Cm)
#X=F4, 1H direct dim    (Hm)

#goto FT234
#goto RECONSTRUCT

rm -fr ft1

date

xyz2pipe -in fid/test%03d.fid -x                       \
| nmrPipe  -fn POLY -time                              \
| nmrPipe  -fn SP -off 0.5 -end 0.98 -pow 2 -c 0.5     \
| nmrPipe  -fn ZF -zf 2 -auto                          \
| nmrPipe  -fn FT                                      \
| nmrPipe  -fn POLY -auto -ord 2 -x1 3ppm -xn -1ppm    \
| nmrPipe  -fn EXT -x1 1.4ppm -xn -0.7ppm -sw -round 2 \
| nmrPipe  -fn PS -p0 122 -p1 0 -di                    \
| pipe2xyz -ov -out ft1/test%03d.ft1 -a

RECONSTRUCT:
rm -fr ft1.smile

date

xyz2pipe -in ft1/test%03d.ft1 -x                     \
| nmrPipe  -fn SMILE -nDim 4 -thresh 0.9 -nThread 16 \
           -maxMem 40 -sample nuslist -report 2      \
           -xP0   0 -xP1   0 -xNeg                   \
           -yP0   3 -yP1   0 -yNeg                   \
           -zP0  87 -zP1 180                         \
| pipe2xyz -out ft1.smile/test%03d.ft1 -x

date

FT234:
rm -fr ft

xyz2pipe -in ft1.smile/test%03d.ft1 -x                \
| nmrPipe  -fn ZF -zf 2 -auto                         \
| nmrPipe  -fn FT -neg                                \
| nmrPipe  -fn PS -p0 0 -p1 0 -di                     \
| nmrPipe  -fn TP                                     \
| nmrPipe  -fn ZF -zf 2 -auto                         \
| nmrPipe  -fn FT -neg                                \
| nmrPipe  -fn PS -p0 3 -p1 0 -di                     \
| pipe2xyz -out ft/test%03d.ft3 -y

xyz2pipe -in ft/test%03d.ft3 -z                       \
| nmrPipe  -fn ZF -zf 2 -auto                         \
| nmrPipe  -fn FT                                     \
| nmrPipe  -fn PS -p0 87 -p1 180 -di                  \
| pipe2xyz -out ft/test%03d.ft4 -z

date

rm -fr *dat

proj4D.tcl -in ft/test%03d.ft4

cd ft
rm -fr test*.ft3
cd ..

