#!/bin/csh

rm -fr ft1

xyz2pipe -in fid/test%03d.fid -x                        \
| nmrPipe -fn SOL                                       \
| nmrPipe -fn SP -off 0.5 -end 0.95 -pow 2 -c 0.5       \
| nmrPipe -fn ZF -zf 2 -auto                            \
| nmrPipe -fn FT                                        \
| nmrPipe -fn PS -p0 146.0 -p1 0.0 -di                  \
| nmrPipe -fn EXT -x1 10.5ppm -xn 5.5ppm -sw            \
| pipe2xyz -out ft1/test%04d.ft1 -z -ov

rm -fr ft1.smile

xyz2pipe -in ft1/test%04d.ft1 -x -verb \
| nmrPipe -fn SMILE -sample nuslist -report 1           \
                    -xApod SP -xQ1 0.5 -xQ2 0.98 -xQ3 1 \
                    -yApod SP -yQ1 0.5 -yQ2 0.98 -yQ3 2 \
                    -xT  46 -xAlt -xP0 0 -xP1   0       \
                    -yT 150 -yAlt -yP0 7 -yP1 -14       \
| pipe2xyz -out ft1.smile/test%04d.ft1 -x -ov

rm -fr ft.tmp

xyz2pipe -in ft1.smile/test%04d.ft1 -x                  \
| nmrPipe -fn ZF -zf 1 -auto                            \
| nmrPipe -fn FT -alt                                   \
| nmrPipe -fn PS -p0 0.0 -p1 0.0 -di                    \
| nmrPipe -fn TP                                        \
| nmrPipe -fn ZF -zf 1 -auto                            \
| nmrPipe -fn FT -alt                                   \
| nmrPipe -fn PS -p0 7 -p1 -14 -di                      \
| pipe2xyz -out ft.tmp/test%04d.ft3 -x -ov

rm -fr smile

xyz2pipe -in ft.tmp/test%04d.ft3 -z                     \
| nmrPipe -fn POLY -auto -ord 2                         \
| pipe2xyz -out smile/test%04d.ft3 -x -ov

rm -rf ft1 ft1.smile ft.tmp *.dat

proj3D.tcl -in smile/test%04d.ft3

