#!/bin/csh

bruk2pipe -in ./ser \
  -bad 0.0 -aswap -DMX -decim 1584 -dspfvs 20 -grpdly 67.987060546875  \
  -xN              2048  -yN                92  -zN               300  \
  -xT              1024  -yT                46  -zT               150  \
  -xMODE            DQD  -yMODE        Complex  -zMODE        Complex  \
  -xSW        12626.263  -ySW         2283.105  -zSW        11627.907  \
  -xOBS         900.274  -yOBS          91.234  -zOBS         900.274  \
  -xCAR           4.678  -yCAR         116.530  -zCAR           4.678  \
  -xLAB              HN  -yLAB             15N  -zLAB              1H  \
  -ndim               3  -aq2D          States                         \
  -out ./fid/test%03d.fid -verb -ov

# The script below converts the list of bad FIDs in overflow.txt and/or overflow_log_dru1.txt
#    to an NUS sampling list that excludes the time points corresponding to these FIDs.
#
# In the overflow.txt file, users can add one FID number or a range of FID numbers (inclusive)
#    per line, and the script inteprets them correctly. For Topspin 2.x, those FID numbers can
#    be obtained manually from Topspin's fid tab (see FIDs11800_12515.png included) by placing
#    the cursor on top of the bad FIDs. Topspin 3.x automatically creates a log file (overflow_log_dru1.txt)
#    for the bad FIDs, and this file can be read in by the script below. One of the two optiions
#    (--fidList and --overflowLog) must be used to provide the bad file list. If both are provided,
#    the bad FIDs in both files are read in.
#
# This script works for 2D, 3D, or 4D uniformly sampled data. It automatically figures out the
#    number of dimensions from the --yT, --zT, and --aT arguments that are set by users. The defaults
#    are 1 for all of them. Set them to the same values corresponding to -yT, -zT, and -aT in the
#    above conversion script. 
#

createList.py --yT 46 --zT 150 --fidList overflow.txt --overflowLog overflow_log_dru1.txt > nuslist

